import matplotlib.pyplot as plt
import seaborn as sns
import os
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.metrics import classification_report, confusion_matrix
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.preprocessing import StandardScaler
from sklearn.cluster import KMeans
from sklearn.metrics import silhouette_score
import numpy as np
from scipy import stats
import sys
sys.path.append(sys.argv[1])

import pandas as pd   
import pickle
from decision_company import read_csv_file, avg, locate_mode, get_max, get_min_value, calculate_median

# Load the dataset  
credit_customers = read_csv_file(os.path.join(sys.argv[1], 'credit_customers.csv'))  
  
# Descriptive statistics for age  
age_column = credit_customers['age']  
age_mean = avg(age_column)  
age_median = calculate_median(credit_customers, 'age')  
age_mode = locate_mode(age_column)[0]  
age_range = get_max(age_column) - get_min_value(age_column) 
  
print(f"Age - Mean: {age_mean}, Median: {age_median}, Mode: {age_mode}, Range: {age_range}")  
# pickle.dump(age_mean, open("./ref_result/age_mean.pkl","wb"))
# pickle.dump(age_median, open("./ref_result/age_median.pkl","wb"))
# pickle.dump(age_mode, open("./ref_result/age_mode.pkl","wb"))
# pickle.dump(age_range, open("./ref_result/age_range.pkl","wb"))

  

import pandas as pd   
import matplotlib.pyplot as plt   
import seaborn as sns
from decision_company import read_csv_file, create_histogram, create_figure, set_plot_xlabel, create_figure, set_plot_title, set_yaxis_label, show_plots, save_plot

# Load the dataset  
  
# Distribution plot for age  
create_figure((10, 6))  
create_histogram(data=credit_customers, x='age', kde=True, bins=20)  
set_plot_title("Age Distribution")  
set_plot_xlabel("Age")  
set_yaxis_label("Frequency")  
save_plot('./ref_result/histplot.png')  
# show_plots()   


import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values

# Load the dataset  
  
# Descriptive statistics for employment status  
employment_column = credit_customers['employment'] 
employment_counts = count_unique_values(employment_column)  

print("\nEmployment Status Distribution:")  
print(employment_counts) 
# pickle.dump(employment_counts,open("./ref_result/employment_counts.pkl","wb"))

import pandas as pd  
import matplotlib.pyplot as plt  
import seaborn as sns  
from decision_company import read_csv_file, create_countplot, create_figure, set_plot_xlabel, create_figure, set_plot_title, set_yaxis_label, show_plots, save_plot

# Load the dataset  
   
# Distribution plot for employment status  
create_figure((10, 6))  
create_countplot(data=credit_customers, x='employment', order=employment_counts.index)  
set_plot_title("Employment Status Distribution")  
set_plot_xlabel("Employment Status")  
set_yaxis_label("Frequency")  
save_plot('./ref_result/countplot.png')  
# show_plots()  


import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values

# Load the dataset  
  
# Descriptive statistics for credit history  
credit_history_column = credit_customers['credit_history']
credit_history_counts = count_unique_values(credit_history_column) 

print("\nCredit History Distribution:")  
print(credit_history_counts)  
# pickle.dump(credit_history_counts,open("./ref_result/credit_history_counts.pkl","wb"))

import pandas as pd   
import matplotlib.pyplot as plt  
import seaborn as sns  
from decision_company import read_csv_file, create_countplot, set_current_ticks, create_figure, set_plot_xlabel, create_figure, set_plot_title, set_yaxis_label, show_plots, save_plot

# Load the dataset  
  
# Distribution plot for credit history  
create_figure((10, 6))  
create_countplot(data=credit_customers, x='credit_history', order=credit_history_counts.index)  
set_plot_title("Credit History Distribution")  
set_plot_xlabel("Credit History")  
set_yaxis_label("Frequency")  
set_current_ticks(rotation=45)  
save_plot('./ref_result/countplot_2.png')  
# show_plots()  


import pandas as pd  
import scipy.stats as stats  
import pickle 
from decision_company import read_csv_file, logical_and

# Load the dataset  
  
# Create a new column to identify younger customers (aged 18-35)  
age_column = credit_customers['age'] 
credit_customers['young_customer'] = logical_and(age_column >= 18, age_column <= 35)  

print("credit_young_customer")
print(credit_customers['young_customer'])  
# pickle.dump(credit_customers['young_customer'],open("./ref_result/credit_young_customer.pkl","wb"))

import pandas as pd  
import pickle
from decision_company import read_csv_file, check_elements_in_list

# Load the dataset  
  
# Filter customers with good credit history  
credit_history_column = credit_customers['credit_history']
good_credit_history = check_elements_in_list(credit_history_column, ['existing paid', 'no credits/all paid', 'all paid'])  

print(good_credit_history)  
# pickle.dump(good_credit_history,open("./ref_result/good_credit_history.pkl","wb"))



import pandas as pd  
import pickle
from decision_company import read_csv_file, access_dataframe_loc, access_dataframe_loc, logical_and

# Load the dataset  
  
# Create groups based on young_customer and good_credit_history  
group1 = access_dataframe_loc(credit_customers, logical_and(credit_customers['young_customer'], good_credit_history), 'credit_amount')  
group2 = access_dataframe_loc(credit_customers, logical_and(~credit_customers['young_customer'], good_credit_history), 'credit_amount')  
group3 = access_dataframe_loc(credit_customers, logical_and(credit_customers['young_customer'], ~good_credit_history), 'credit_amount')  
group4 = access_dataframe_loc(credit_customers, logical_and(~credit_customers['young_customer'], ~good_credit_history), 'credit_amount')  
  
 
pickle.dump(group1,open("./ref_result/group1.pkl","wb"))
pickle.dump(group2,open("./ref_result/group2.pkl","wb"))
pickle.dump(group3,open("./ref_result/group3.pkl","wb"))
pickle.dump(group4,open("./ref_result/group4.pkl","wb"))